<?php
namespace Dalten\WebAdminBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\CallbackTransformer;

class UserEditType extends AbstractType
{
	/**
	 * @param FormBuilderInterface $builder
	 * @param array $options
	 */
	public function buildForm(FormBuilderInterface $builder, array $options)
	{
        $builder
            ->add('username', 'Symfony\Component\Form\Extension\Core\Type\TextType', array('label'=>'Uživatelské jméno', 'disabled'=>true))
            ->add('email', 'Symfony\Component\Form\Extension\Core\Type\TextType', array('label'=>'E-mail', 'disabled'=>true))
            ->add('roles', 'Symfony\Component\Form\Extension\Core\Type\TextareaType', array('label'=>'Role'))
            ->add('plain_password', 'Symfony\Component\Form\Extension\Core\Type\TextType', array('label'=>'Nastavit heslo', 'required'=>false))
        ;

		// převádí data z entity do formuláře a naopak
		$builder->get('roles')
			->addModelTransformer(new CallbackTransformer(
				function ($tagsAsArray) {
					// transform the array to a string
					return implode(PHP_EOL, $tagsAsArray);
				},
				function ($tagsAsString) {
					// transform the string back to an array
					return explode(PHP_EOL, $tagsAsString);
				}
			))
		;
	}

	/**
	 * @param OptionsResolver $resolver
	 */
	public function configureOptions(OptionsResolver $resolver)
	{
		$resolver->setDefaults(array(
			'data_class' => 'Dalten\WebAdminBundle\Entity\User'
		));
	}
}