<?php
require __DIR__ . '/lib/Dalten/Import/PDOWrapper.php';

$db = \Dalten\Import\PDOWrapper::connectToMySQL('localhost', 'import_rscs', 'root', 'qwer');

include 'data_RSCS.php';

if (empty($data) || empty($section_names)) {
	die('Nedostatecne informace k importu.');
}

//
// naimportuje existující realwebí obsah do struktury databáze webadminu
//

$db->perform('SET sql_mode=""'); // nestriktni mod SQL, aby nepadal import

foreach ($data as $sectionSlug=>$clanky) {
	$idSekce = $db->insertRow('section', array(
		'name' => $section_names[$sectionSlug],
		'slug' => $sectionSlug
	));

	if ($sectionSlug=='aktuality') {
		// aktuality importujeme trochu jinak
		foreach ($clanky as $idClanku=>$clanek) {
			$db->insertRow('blogpost', array(
				'name' => $clanek['nadpis'],
				'teaser' => '...',
				'html' => $clanek['text'],
				'slug' => 'aktuality-rscs?clanek=' .$idClanku,
				'date_published' => dmY2Ymd($clanek['datum'])
			));
		}

		continue;
	}

	foreach ($clanky as $idClanku=>$clanek) {
		$idVlozenehoClanku = $db->insertRow('article', array(
			'id_section' => $idSekce,
			'name' => $clanek['nadpis'],
			'teaser' => '...',
			'html' => $clanek['text'],
			'slug' => $sectionSlug . '?s=' . $idClanku,
			'is_published' => 1,
			'revision_number' => 1
		));

		$db->insertRow('article_history', array(
			'id_article' => $idVlozenehoClanku,
			'revision_number' => 1,
			'name' => $clanek['nadpis'],
			'teaser' => '...',
			'html' => $clanek['text'],
			'revision_author' => 'import',
			'revision_date' => dmY2Ymd($clanek['datum']),
			'is_autosave' => 0
		));
	}
}

echo 'import OK';

function dmY2Ymd ($date) {
	$datum = array();
	if (preg_match("/([0-9]{1,2})\.([0-9]{1,2})\.([0-9]{2,4})/is", $date, $datum)) {
		$time = mktime(0,0,0,$datum[2],$datum[1],$datum[3]);
		$date=date("Y-m-d", $time);
		if (!$time || ($datum[2]!=date("m",mktime(0,0,0,$datum[2],$datum[1],$datum[3])))||($datum[1]!=date("d",mktime(0,0,0,$datum[2],$datum[1],$datum[3])))) {
			return "0000-00-00";
		} else {
			return $date;
		}
	}
	return "0000-00-00";
}