<?php

namespace Dalten\WebAdminBundle\Entity;

use Dalten\WebBundle\Entity\Broker as WebBroker;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\MappedSuperclass
 * @ORM\Table(name="uzivatel")
 */
class Broker extends WebBroker
{

	/**
     * @var \Dalten\WebAdminBundle\Entity\BrokerArticles
     */
    private $article;

    /**
     * @var ArrayCollection
     */
    private $blogposts;

    /**
     * @var ArrayCollection
     */
    private $references;

    public function __construct()
    {
		parent::__construct();
        $this->blogposts = new ArrayCollection();
        $this->references = new ArrayCollection();
    }

    /**
     * @return ArrayCollection
     */
    public function getBlogposts()
    {
        return $this->blogposts;
    }

    /**
     * @param ArrayCollection $blogposts
     */
    public function setBlogposts($blogposts)
    {
        $this->blogposts = $blogposts;
    }

    /**
     * @return int
     */
    public function getArticle()
    {
        return $this->article;
    }

    /**
     * @param int $article
     */
    public function setArticle($article)
    {
        $this->article = $article;
    }

    public function __toString()
    {
        return $this->first_name . " " . $this->last_name;
    }

    /**
     * Add blogpost
     *
     * @param \App\FrontBundle\Entity\Blogpost $blogpost
     *
     * @return Broker
     */
    public function addBlogpost(\App\FrontBundle\Entity\Blogpost $blogpost)
    {
        $this->blogposts[] = $blogpost;

        return $this;
    }

    /**
     * Remove blogpost
     *
     * @param \App\FrontBundle\Entity\Blogpost $blogpost
     */
    public function removeBlogpost(\App\FrontBundle\Entity\Blogpost $blogpost)
    {
        $this->blogposts->removeElement($blogpost);
    }

    /**
     * @param Reference $reference
     * @return $this
     */
    public function addReference(\App\FrontBundle\Entity\Reference $reference)
    {
        $this->references[] = $reference;

        return $this;
    }

    /**
     * @param Reference $reference
     */
    public function removeReference(\App\FrontBundle\Entity\Reference $reference)
    {
        $this->references->removeElement($reference);
    }

    /**
     * @return ArrayCollection
     */
    public function getReferences()
    {
        return $this->references;
    }

    /**
     * @param ArrayCollection $references
     */
    public function setReferences(ArrayCollection $references)
    {
        $this->references = $references;
    }
}
