<?php

namespace Dalten\WebAdminBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class BrokerArticlesType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('servicesPerex', TextType::class, ['label' => 'Služby perex', 'required' => false])
            ->add('services', TextareaType::class, [
                'label' => 'Služby',
                'required' => false,
                'attr' => ['class' => 'tinymce']
            ])
            ->add('personalPerex', TextType::class, ['label' => 'Osobní perex', 'required' => false])
            ->add('personal', TextareaType::class, [
                'label' => 'Osobní',
                'required' => false,
                'attr' => ['class' => 'tinymce']
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Dalten\WebAdminBundle\Entity\BrokerArticles'
        ));
    }

}
