<?php

namespace Dalten\WebAdminBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

use Dalten\WebAdminBundle\Entity\Banner;
use Dalten\WebAdminBundle\Form\BannerType;

/**
 * Banner controller.
 *
 */
class BannerController extends Controller
{
    /**
     * Lists all Banner entities.
     *
     */
    public function indexAction()
    {
        $this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

        $em = $this->getDoctrine()->getManager();

        $banners = $em->getRepository('DaltenWebAdminBundle:Banner')->findAll();

        return $this->render('DaltenWebAdminBundle:banner:index.html.twig', array(
            'banners' => $banners,
        ));
    }

    /**
     * Creates a new Banner entity.
     *
     */
    public function newAction(Request $request)
    {
        $this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

        $banner = new Banner();
        $form = $this->createForm('Dalten\WebAdminBundle\Form\BannerType', $banner);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($banner);
            $em->flush();

            return $this->redirectToRoute('webadmin_banner_show', array('id' => $banner->getId()));
        }

        return $this->render('DaltenWebAdminBundle:banner:new.html.twig', array(
            'banner' => $banner,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a Banner entity.
     *
     */
    public function showAction(Banner $banner)
    {
        $this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

        $deleteForm = $this->createDeleteForm($banner);

        return $this->render('DaltenWebAdminBundle:banner:show.html.twig', array(
            'banner' => $banner,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing Banner entity.
     *
     */
    public function editAction(Request $request, Banner $banner)
    {
        $this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

        $deleteForm = $this->createDeleteForm($banner);
        $editForm = $this->createForm('Dalten\WebAdminBundle\Form\BannerType', $banner);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($banner);
            $em->flush();

            return $this->redirectToRoute('webadmin_banner_edit', array('id' => $banner->getId()));
        }

        return $this->render('DaltenWebAdminBundle:banner:edit.html.twig', array(
            'banner' => $banner,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a Banner entity.
     *
     */
    public function deleteAction(Request $request, Banner $banner)
    {
        $this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

        $form = $this->createDeleteForm($banner);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($banner);
            $em->flush();
        }

        return $this->redirectToRoute('webadmin_banner_index');
    }

    /**
     * Creates a form to delete a Banner entity.
     *
     * @param Banner $banner The Banner entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Banner $banner)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('webadmin_banner_delete', array('id' => $banner->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
