<?php

namespace Dalten\WebAdminBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

use Dalten\WebAdminBundle\Entity\Section;
use Dalten\WebAdminBundle\Form\SectionType;

/**
 * Section controller.
 *
 */
class SectionController extends Controller
{
	/**
	 * Lists all Section entities.
	 *
	 */
	public function indexAction()
	{
		$this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

		$em = $this->getDoctrine()->getManager();

		$sections = $em->getRepository('DaltenWebAdminBundle:Section')->findAll();

		return $this->render('DaltenWebAdminBundle:sections:index.html.twig', array(
			'sections' => $sections,
		));
	}

	/**
	 * Creates a new Section entity.
	 *
	 */
	public function newAction(Request $request)
	{
		$this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

		$section = new Section();
		$form = $this->createForm('Dalten\WebAdminBundle\Form\SectionType', $section);
		$form->handleRequest($request);

		if ($form->isSubmitted() && $form->isValid()) {
			$em = $this->getDoctrine()->getManager();
			$em->persist($section);
			$em->flush();

			return $this->redirectToRoute('webadmin_sections_index');
		}

		return $this->render('DaltenWebAdminBundle:sections:new.html.twig', array(
			'section' => $section,
			'form' => $form->createView(),
		));
	}

	/**
	 * Finds and displays a Section entity.
	 *
	 */
	public function showAction(Section $section)
	{
		$this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

		$deleteForm = $this->createDeleteForm($section);

		return $this->render('DaltenWebAdminBundle:sections:show.html.twig', array(
			'section' => $section,
			'delete_form' => $deleteForm->createView(),
		));
	}

	/**
	 * Displays a form to edit an existing Section entity.
	 *
	 */
	public function editAction(Request $request, Section $section)
	{
		$this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

		$deleteForm = $this->createDeleteForm($section);
		$editForm = $this->createForm('Dalten\WebAdminBundle\Form\SectionType', $section);
		$editForm->handleRequest($request);

		if ($editForm->isSubmitted() && $editForm->isValid()) {
			$em = $this->getDoctrine()->getManager();
			$em->persist($section);
			$em->flush();

			return $this->redirectToRoute('webadmin_sections_index');
		}

		return $this->render('DaltenWebAdminBundle:sections:edit.html.twig', array(
			'section' => $section,
			'edit_form' => $editForm->createView(),
			'delete_form' => $deleteForm->createView(),
		));
	}

	/**
	 * Deletes a Section entity.
	 *
	 */
	public function deleteAction(Request $request, Section $section)
	{
		$this->denyAccessUnlessGranted('ROLE_USER', null, 'Only for logged-in users.');

		$form = $this->createDeleteForm($section);
		$form->handleRequest($request);

		if ($form->isSubmitted() && $form->isValid()) {
			$em = $this->getDoctrine()->getManager();
			$em->remove($section);
			$em->flush();
		}

		return $this->redirectToRoute('webadmin_sections_index');
	}

	/**
	 * Creates a form to delete a Section entity.
	 *
	 * @param Section $section The Section entity
	 *
	 * @return \Symfony\Component\Form\Form The form
	 */
	private function createDeleteForm(Section $section)
	{
		return $this->createFormBuilder()
			->setAction($this->generateUrl('webadmin_sections_delete', array('id' => $section->getId())))
			->setMethod('DELETE')
			->getForm()
		;
	}
}
