<?php

namespace Dalten\WebAdminBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Cocur\Slugify\Slugify;

/**
 * Article
 *
 * @ORM\Table(name="article", uniqueConstraints={@ORM\UniqueConstraint(name="slug", columns={"slug"})}, indexes={@ORM\Index(name="id_section", columns={"id_section"})})
 * @ORM\MappedSuperclass
 */
class Article
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255, nullable=false)
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="teaser", type="string", length=255, nullable=true)
     */
    private $teaser;

    /**
     * @var string
     *
     * @ORM\Column(name="html", type="text", length=16777215, nullable=true)
     */
    private $html;

    /**
     * @var string
     *
     * @ORM\Column(name="slug", type="string", length=255, nullable=false)
     */
    private $slug;

    /**
     * @var boolean
     *
     * @ORM\Column(name="is_published", type="boolean", nullable=false)
     */
    private $isPublished;

    /**
     * @var integer
     *
     * @ORM\Column(name="revision_number", type="integer", nullable=false)
     */
    private $revisionNumber;

    /**
     * @var string
     *
     * @ORM\Column(name="old_slug", type="string", length=255, nullable=true)
     */
    private $oldSlug;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="deleted_at", type="datetime", nullable=true)
     */
    private $deletedAt;

    /**
     * @var \App\FrontBundle\Entity\Broker
     *
     * @ORM\OneToOne(targetEntity="App\FrontBundle\Entity\Broker")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="broker_id", referencedColumnName="id", unique=true)
     * })
     */
    private $broker;

    /**
     * @var \App\FrontBundle\Entity\Section
     *
     * @ORM\ManyToOne(targetEntity="App\FrontBundle\Entity\Section")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="id_section", referencedColumnName="id")
     * })
	 * @ORM\OrderBy({"name" = "ASC"})
     */
    private $idSection;


	/**
	 * Get id
	 *
	 * @return integer
	 */
	public function getId()
	{
		return $this->id;
	}

	/**
	 * Set name
	 *
	 * @param string $name
	 * @return Article
	 */
	public function setName($name)
	{
		$this->name = $name;

		return $this;
	}

	/**
	 * Get name
	 *
	 * @return string
	 */
	public function getName()
	{
		return $this->name;
	}


	/**
	 * Set teaser
	 *
	 * @param string $teaser
	 * @return Article
	 */
	public function setTeaser($teaser)
	{
		$this->teaser = $teaser;

		return $this;
	}

	/**
	 * Get teaser
	 *
	 * @return string
	 */
	public function getTeaser()
	{
		return $this->teaser;
	}

	/**
	 * Set html
	 *
	 * @param string $html
	 * @return Article
	 */
	public function setHtml($html)
	{
		$this->html = $html;

		return $this;
	}

	/**
	 * Get html
	 *
	 * @return string
	 */
	public function getHtml()
	{
		return $this->html;
	}

	/**
	 * Set slug
	 *
	 * @param string $slug
	 * @return Article
	 */
	public function setSlug($slug)
	{
		$this->slug = $slug;

		return $this;
	}

	/**
	 * Get slug
	 *
	 * @return string
	 */
	public function getSlug()
	{
		return $this->slug;
	}

	/**
	 * Set idSection
	 *
	 * @param \App\FrontBundle\Entity\Section $idSection
	 * @return Article
	 */
	public function setIdSection(\App\FrontBundle\Entity\Section $idSection = null)
	{
		$this->idSection = $idSection;

		return $this;
	}

	/**
	 * Get idSection
	 *
	 * @return \App\FrontBundle\Entity\Section
	 */
	public function getIdSection()
	{
		return $this->idSection;
	}

	public function getIsPublished()
	{
		return $this->isPublished;
	}

	public function setIsPublished($published)
	{
		return $this->isPublished = $published;
	}

	public function getRevisionNumber()
	{
		return $this->revisionNumber;
	}

	public function setRevisionNumber($revisionNumber)
	{
		return $this->revisionNumber = $revisionNumber;
	}

    public function getOldSlug()
    {
        return $this->oldSlug;
    }

    public function setOldSlug($oldSlug)
    {
        return $this->oldSlug = $oldSlug;
    }

	public function regenerateSlug()
	{
		$slugify = new Slugify();
		$this->slug =  $slugify->slugify($this->name);
	}

    /**
     * Get deleted at
     *
     * @return string
     */
    public function getDeletedAt()
    {
        return $this->deletedAt;
    }

    /**
     * Set deleted at
     *
     * @param $deletedAt
     */
    public function setDeletedAt($deletedAt)
    {
        $this->deletedAt = $deletedAt;
    }

    /**
     * @return Broker
     */
    public function getBroker()
    {
        return $this->broker;
    }

    /**
     * @param Broker $broker
     */
    public function setBroker($broker)
    {
        $this->broker = $broker;
    }
}
