<?php

namespace Dalten\WebAdminBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class BannerType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', 'text', array('label'=>'Kód pozice banneru'))
            ->add('label', 'text', array('label'=>'Název pozice banenru'))
            ->add('targetUrl', 'text', array('label'=>'Cílová URL'))
            ->add('imageUrl', 'elfinder', array('label'=>'Obrázek na banneru', 'instance'=>'form', 'enable'=>true))
            ->add('active', 'checkbox', array('label'=>'Zobrazeno?'))
        ;
    }
    
    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Dalten\WebAdminBundle\Entity\Banner'
        ));
    }
}
