<?php

namespace Dalten\WebAdminBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\NotBlank;

class BlogpostType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', 'text', array('label'=>'Název', 'constraints' => new NotBlank()))
            ->add('teaser', 'textarea', array('label'=>'Upoutávka', 'constraints' => new NotBlank()))
            ->add('html', 'textarea', array('attr'=>array('class'=>'tinymce'), 'label'=>'Text aktuality'))
            ->add('datePublished', 'datetime', array('label'=>'Publikováno'))
        ;
        if ($options['broker_selection']) {
            $builder
                ->add('broker', 'entity', [
                    'label' => 'Makléř',
                    'required' => false,
                    'class' => 'Dalten\WebAdminBundle\Entity\Broker',
                    'empty_value' => '- nevybráno -',
                    'choices_as_values' => true
                ]);
        }
    }
    
    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Dalten\WebAdminBundle\Entity\Blogpost',
            'broker_selection' => false
        ));
    }
}
