<?php


namespace Dalten\WebAdminBundle\Helper;
use \FOS\UserBundle\Form\Factory\FactoryInterface;
use \FOS\UserBundle\Model\UserManagerInterface;

/**
 * Pomocná třída, která přináší závislosti pro formulář registrace uživatele. Jinak to k ničemu není.
 */
class RegistrationDependencies
{
    protected $_formFactory;
    protected $_userManager;


    public function __construct(FactoryInterface $formFactory, UserManagerInterface $userManager)
    {
        $this->_formFactory = $formFactory;
        $this->_userManager = $userManager;
    }

    /**
     * @return FactoryInterface
     */
    public function getFormFactory()
    {
        return $this->_formFactory;
    }

    /**
     * @return UserManagerInterface
     */
    public function getUserManager()
    {
        return $this->_userManager;
    }
}