# RUIAN

Oficiální dokumentace výměnných souborů bydlí na http://www.cuzk.cz/vfr.

## Zjednodušené struktura záznamů
[doc/structure.txt](doc/structure.txt)

Možná nebude zcela aktuální. V případě potřeby je možno vygenerovat novou pomocí:

`php console explore`

## Číselníky
Je možné vygenerovat aktuální seznam číselníků pomocí následujícího commandu:

`php console get-codebooks > codebooks.txt`.

Kopie v YAMLu je v [doc/RUIAN-codebooks.yml](doc/RUIAN-codebooks.yml).


## Popis položek

### Adresní místo
#### Vlastnosti
* Kód
* Domovní číslo
* PSČ
* ID stavebního objektu
* ID ulice
* GPS
* Stav
* Platnost od


#### Dohledatelnost
| Druh položky | Je dohledatelná? |
| ------------ | ---------------- |
| Adresní místo | X |
| Stavební objekt | **Ano, přímo**
| Parcela | **Ano, přes objekt**
| Ulice | **Ano, přímo**
| Katastrální území | **Ano, přes ulici nebo parcelu**
| Část obce | **Ano, přes objekt**
| Mětská část | **Ano, přes objekt**
| Pražský obvod | **Ano, přes městskou část**
| Obec | **Ano, přes ulici, KÚ, část obce a pražský obvod**
| Okres | **Ano, přes obec**
| Kraj | **Ano, přes okres**

### Stavební objekt
#### Vlastnosti
* Kód
* Domovní číslo
* ID parcely
* ID části obce
* ID městské části
* Typ stavebního objektu
* Způsob využití objektu
* Druh konstrukce budovy
* Počet bytů
* Počet podlaží
* Druh připojení kanalizace
* Druh připojení plynu
* Druh připojení vodovodu
* Vybavení výtahem
* Způsob vytápění
* GPS


#### Dohledatelnost
| Druh položky | Je dohledatelná? |
| ------------ | ---------------- |
| Adresní místo | Ne |
| Stavební objekt | X |
| Parcela | **Ano, přímo**
| Ulice | Ne (pouze pokud má alespoň jedno adresní místo) |
| Katastrální území | **Ano, přes parcelu**
| Část obce | **Ano, přímo**
| Mětská část | **Ano, přímo**
| Pražský obvod | **Ano, přes městskou část**
| Obec | **Ano, přes KÚ, část obce a pražský obvod**
| Okres | **Ano, přes obec**
| Kraj | **Ano, přes okres**

### Parcela
#### Vlastnosti
* Kód
* Kmenové číslo
* Výměra
* ID katastrálního území
* Druh pozemku
* Druh číslování
* GPS


#### Dohledatelnost
| Druh položky | Je dohledatelná? |
| ------------ | ---------------- |
| Adresní místo | Ne |
| Stavební objekt | Ne |
| Parcela | X |
| Ulice | Ne |
| Katastrální území | **Ano, přímo** |
| Část obce | Ne |
| Mětská část | Ne |
| Pražský obvod | Ne |
| Obec | **Ano, přes KÚ** |
| Okres | **Ano, přes obec** |
| Kraj | **Ano, přes okres** |

### Ulice
#### Vlastnosti
* Kód
* Název
* ID obce


#### Dohledatelnost
| Druh položky | Je dohledatelná? |
| ------------ | ---------------- |
| Adresní místo | Ne |
| Stavební objekt | Ne |
| Parcela | Ne |
| Ulice | X |
| Katastrální území | Ne |
| Část obce | Ne |
| Mětská část | Ne |
| Pražský obvod | Ne |
| Obec | **Ano, přímo** |
| Okres | **Ano, přes obec** |
| Kraj | **Ano, přes okres** |

### Katastrální území
#### Vlastnosti
* Kód
* Název
* ID obce
* Datum vzniku
* Skloňování názvu
* GPS


#### Dohledatelnost
| Druh položky | Je dohledatelná? |
| ------------ | ---------------- |
| Adresní místo | Ne |
| Stavební objekt | Ne |
| Parcela | Ne |
| Ulice | Ne |
| Katastrální území | X |
| Část obce | Ne |
| Mětská část | Ne |
| Pražský obvod | Ne |
| Obec | **Ano, přímo** |
| Okres | **Ano, přes obec** |
| Kraj | **Ano, přes okres** |

### Část obce
#### Vlastnosti
* Kód
* Název
* ID obce
* Datum vzniku
* Skloňování názvu
* GPS


#### Dohledatelnost
| Druh položky | Je dohledatelná? |
| ------------ | ---------------- |
| Adresní místo | Ne |
| Stavební objekt | Ne |
| Parcela | Ne |
| Ulice | Ne |
| Katastrální území | Ne |
| Část obce | X |
| Mětská část | Ne |
| Pražský obvod | Ne |
| Obec | **Ano, přímo** |
| Okres | **Ano, přes obec** |
| Kraj | **Ano, přes okres** |

### Mětská část
#### Vlastnosti
* Kód
* Název
* ID obce
* ID pražského obvodu
* ~~ID správního obvodu~~
* Popis vlajky
* Popis znaku
* Datum vzniku
* Skloňování názvu
* GPS


#### Dohledatelnost
| Druh položky | Je dohledatelná? |
| ------------ | ---------------- |
| Adresní místo | Ne |
| Stavební objekt | Ne |
| Parcela | Ne |
| Ulice | Ne |
| Katastrální území | Ne |
| Část obce | Ne |
| Mětská část | X |
| Pražský obvod | **Ano, přímo** |
| Obec | **Ano, přímo** |
| Okres | **Ano, přes obec** |
| Kraj | **Ano, přes okres** |

### Pražský obvod
#### Vlastnosti
* Kód
* Název
* ID obce
* Datum vzniku
* GPS


#### Dohledatelnost
| Druh položky | Je dohledatelná? |
| ------------ | ---------------- |
| Adresní místo | Ne |
| Stavební objekt | Ne |
| Parcela | Ne |
| Ulice | Ne |
| Katastrální území | Ne |
| Část obce | Ne |
| Mětská část | Ne |
| Pražský obvod | X |
| Obec | **Ano, přímo** |
| Okres | **Ano, přes obec** |
| Kraj | **Ano, přes okres** |

### Obec
#### Vlastnosti
* Kód
* Název
* ID okresu
* Datum vzniku
* Skloňování názvu
* Popis vlajky
* Rozsah členění (úplně / částečné)
* Typ členění (městský obvod / městská část)
* NUTS
* GPS


#### Dohledatelnost
| Druh položky | Je dohledatelná? |
| ------------ | ---------------- |
| Adresní místo | Ne |
| Stavební objekt | Ne |
| Parcela | Ne |
| Ulice | Ne |
| Katastrální území | Ne |
| Část obce | Ne |
| Mětská část | Ne |
| Pražský obvod | Ne |
| Obec | X |
| Okres | **Ano, přímo** |
| Kraj | **Ano, přes okres** |

### Okres
#### Vlastnosti
* Kód
* Název
* ID kraje
* ID VÚSC (náš kraj)
* Datum vzniku
* NUTS
* GPS


#### Dohledatelnost
| Druh položky | Je dohledatelná? |
| ------------ | ---------------- |
| Adresní místo | Ne |
| Stavební objekt | Ne |
| Parcela | Ne |
| Ulice | Ne |
| Katastrální území | Ne |
| Část obce | Ne |
| Mětská část | Ne |
| Pražský obvod | Ne |
| Obec | Ne |
| Okres | X |
| Kraj | **Ano, přímo** |

### Kraj
#### Vlastnosti
* Kód
* Název
* ~~ID regionu soudržnosti~~
* NUTS
* GPS
* Datum vzniku


#### Dohledatelnost
| Druh položky | Je dohledatelná? |
| ------------ | ---------------- |
| Adresní místo | Ne |
| Stavební objekt | Ne |
| Parcela | Ne |
| Ulice | Ne |
| Katastrální území | Ne |
| Část obce | Ne |
| Mětská část | Ne |
| Pražský obvod | Ne |
| Obec | Ne |
| Okres | Ne |
| Kraj | X |

## Mapa dohledatelnosti

| | Adresa | Objekt | Parcela | Ulice | Katastrální území | Část obce | Městská část | Pražský obvod | Obec | Okres | Kraj  | 
| ------ | ------ | ------ | ------ | ------ | ------ | ------ | ------ | ------ | ------ | ------ | ------  | 
| **Adresa** |  | přímo | přes objekt | přímo | přes ulici/parcelu | přes objekt | přes objekt | přes mčást | více způsobů | přes obec | přes okres  | 
| **Objekt** |  |  | přímo |  | přes parcelu | přímo | přímo | přes mčást | více způsobů | přes obec | přes okres  | 
| **Parcela** |  |  |  |  | přímo |  |  |  | přes KÚ | přes obec | přes okres  | 
| **Ulice** |  |  |  |  |  |  |  |  | přímo | přes obec | přes okres  | 
| **Katastrální území** |  |  |  |  |  |  |  |  | přímo | přes obec | přes okres  | 
| **Část obce** |  |  |  |  |  |  |  |  | přímo | přes obec | přes okres  | 
| **Městská část** |  |  |  |  |  |  |  | přímo | přímo | přes obec | přes okres  | 
| **Pražský obvod** |  |  |  |  |  |  |  |  | přímo | přes obec | přes okres  | 
| **Obec** |  |  |  |  |  |  |  |  |  | přímo | přes okres  | 
| **Okres** |  |  |  |  |  |  |  |  |  |  | přímo  | 
| **Kraj** |  |  |  |  |  |  |  |  |  |  |   | 
