<?php

namespace Dalten\RuianToUir\Converter;

use Dalten\RuianToUir\Converter\Field\PointCoordinatesConverter;

/**
 * Převaděč na entitu adresy.
 */
class Address extends AbstractConverter implements ConverterInterface
{
    /**
     * Nastavuje konfiguraci třídy.
     *
     * @param PointCoordinatesConverter $coordinateConverter
     */
    public function __construct(PointCoordinatesConverter $coordinateConverter)
    {
        parent::__construct($coordinateConverter);
        $this->_handledTag = 'vf:AdresniMisto';
    }

    /**
     * {@inheritdoc}
     */
    public function convert(\XMLReader $document)
    {
        $data = ['stav' => 1];
        while ($this->_getNextElement($document)) {
            switch ($document->name) {
                case 'ami:Kod':
                    $data['adresa_kod'] = (int) $document->readString();

                    break;
                case 'ami:CisloOrientacni':
                    $data['cisor_hod'] = $document->readString();

                    break;
                case 'ami:CisloOrientacniPismeno':
                    $data['cisor_pis'] = $document->readString();

                    break;
                case 'ami:CisloDomovni':
                    $data['cisdom_hod'] = (int) $document->readString();

                    break;
                case 'ami:Psc':
                    $data['psc'] = $document->readString();

                    break;
                case 'ami:StavebniObjekt':
                    if (!$document->isEmptyElement) {
                        $this->_getNextElement($document);
                        if ('soi:Kod' === $document->name) {
                            $data['objekt_kod'] = (int) $document->readString();
                        }
                    }

                    break;
                case 'ami:Ulice':
                    if (!$document->isEmptyElement) {
                        $this->_getNextElement($document);
                        if ('uli:Kod' === $document->name) {
                            $data['ulice_kod'] = (int) $document->readString();
                        }
                    }

                    break;
                case 'ami:Geometrie':
                    if (!$document->isEmptyElement) {
                        $this->_getNextElement($document);
                        if (!$document->isEmptyElement) {
                            $this->_getNextElement($document);
                            // Geometrie adresního bodu
                            if ('ami:AdresniBod' === $document->name && !$document->isEmptyElement) {
                                $data['geom'] = $this->_getGeometryData($document);
                            }
                        }
                    }

                    break;
                default:
                    $this->_skipToElementEnd($document);

                    break;
            }
        }

        return $data;
    }
}
