<?php

namespace Dalten\RuianToUir\Converter;

use Dalten\RuianToUir\Converter\Field\PointCoordinatesConverter;

/**
 * Převaděč na entitu okresu.
 */
class Region extends AbstractConverter implements ConverterInterface
{
    /**
     * Nastavuje konfiguraci třídy.
     *
     * @param PointCoordinatesConverter $coordinateConverter
     */
    public function __construct(PointCoordinatesConverter $coordinateConverter)
    {
        parent::__construct($coordinateConverter);
        $this->_handledTag = 'vf:Okres';
    }

    /**
     * {@inheritdoc}
     */
    public function convert(\XMLReader $document)
    {
        $data = ['stav' => 1];
        while ($this->_getNextElement($document)) {
            switch ($document->name) {
                case 'oki:Kod':
                    $data['okres_kod'] = (int) $document->readString();

                    break;
                case 'oki:Nazev':
                    $data['zkratka'] = $data['nazev'] = (string) $document->readString();

                    break;
                case 'oki:NutsLau':
                    $data['nuts4'] = (string) $document->readString();

                    break;
                case 'oki:Vusc':
                    if (!$document->isEmptyElement) {
                        $this->_getNextElement($document);
                        if ('vci:Kod' === $document->name) {
                            $data['kraj_kod'] = (int) $document->readString();
                        }
                    }

                    break;
                case 'oki:Geometrie':
                    if (!$document->isEmptyElement) {
                        $data['geom'] = $this->_getGeometryData($document);
                    }

                    break;
                default:
                    $this->_skipToElementEnd($document);

                    break;
            }
        }

        return $data;
    }
}
