<?php

namespace Dalten\RuianToUir\Formatter;

/**
 * Formatter, který převádí hodnoty do formátu název1=hodnota1;název2=hodnota2.
 */
class PlainText implements FormatterInterface
{
    /**
     * Převádí hodnoty do formátu TypPoložky;AKCE;název1=hodnota1;název2=hodnota2.
     *
     * @param array  $data          Pole převedených dat.
     * @param string $converterName Název converteru, který provedl převod.
     *
     * @return string Zformátovaný řádek.
     */
    public function format(array $data, $converterName)
    {
        $output = [];
        if ('RemovedItem' === $converterName) {
            $converterName = $data['parent_converter'];
            $output[] = $converterName;
            $output[] = 'DEL';
            $output[] = 'identifier='.$data['identifier'];
        } else {
            $output[] = $converterName;
            $output[] = 'ADD';
            foreach ($data as $name => $value) {
                $output[] = sprintf('%s=%s', $name, $value);
            }
        }

        return implode(';', $output);
    }
}
