<?php

namespace Dalten\RuianToUir\Command;

use Dalten\RuianToUir\Command\Helper\FileResolver;
use Dalten\RuianToUir\Converter\ConverterInterface;
use Dalten\RuianToUir\Converter\ExplorerWrapper;
use Dalten\RuianToUir\Converter\Field\PointCoordinatesConverter;
use Symfony\Component\Console\Command\Command as BaseCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

/**
 * Created by PhpStorm.
 * User: karel
 * Date: 20.02.2017
 * Time: 16:56.
 */
class ConvertCoords extends BaseCommand
{
    /** @var PointCoordinatesConverter  */
    protected $_pointConverter;


    public function __construct(PointCoordinatesConverter $converter)
    {
        parent::__construct();

        $this->_pointConverter = $converter;
    }

    public function execute(InputInterface $input, OutputInterface $output)
    {
        $io = new SymfonyStyle($input, $output);

        $coords = $io->ask('Enter S-JTSK coords to convert (or . to stop):', '.');

        while ($coords != '.') {
            $io->text($this->_pointConverter->convertCoords($coords));
            $coords = $io->ask('Enter S-JTSK coords to convert (or . to stop):', '.');
        }
    }

    protected function configure()
    {
        $this->setName('convert-coords');
        $this->setDescription('Převede S-JTSK souřadnice na GPS.');
    }
}
