<?php

namespace Dalten\RuianToUir\Converter;

use Dalten\RuianToUir\Converter\Field\PointCoordinatesConverter;

/**
 * Převaděč na entitu městské ulice.
 */
class RemovedItem extends AbstractConverter implements ConverterInterface
{
    /**
     * @var array
     */
    private $ruianAddressPartTypeMap;

    /**
     * Nastavuje konfiguraci třídy.
     *
     * @param array                     $ruianAddressPartTypeMap
     * @param PointCoordinatesConverter $coordinateConverter
     */
    public function __construct(PointCoordinatesConverter $coordinateConverter, array $ruianAddressPartTypeMap)
    {
        parent::__construct($coordinateConverter);
        $this->_handledTag = 'vf:ZaniklyPrvek';
        $this->ruianAddressPartTypeMap = $ruianAddressPartTypeMap;
    }

    /**
     * Převádí informace z prvku pod kurzorem do formátu UIR.
     *
     * Protože RUIAN vkládá elementy ulice do sebe, zkusí tato třída zda daný prvek neobsahuje další podobný.
     * Pokud ano, pak zpracuje až vnitřní prvek. Bohužel je toto při přáci s XMLReaderem nutnost.
     *
     * @param \XMLReader $document Instance readeru s kurzorem na testovaném prvku.
     *
     * @return array Pole s daty ve formátu UIR.
     */
    public function convert(\XMLReader $document)
    {
        // <vf:ZaniklyPrvek><vf:TypPrvkuKod>SO</vf:TypPrvkuKod><vf:PrvekId>43628028</vf:PrvekId><vf:IdTransakce>1732987</vf:IdTransakce></vf:ZaniklyPrvek>
        $data = [];

        while ($this->_getNextElement($document)) {
            switch ($document->name) {
                case 'vf:TypPrvkuKod':
                    $type = (string) $document->readString();
                    if (!isset($this->ruianAddressPartTypeMap[$type])) {
                        // tuto věc neřešíme

                        return [];
                    }

                    $data['parent_converter'] = $this->ruianAddressPartTypeMap[$type];

                    break;
                case 'vf:PrvekId':
                    $data['identifier'] = (int) $document->readString();

                    break;
                default:
                    $this->_skipToElementEnd($document);

                    break;
            }
        }

        if (empty($data['parent_converter'])) {
            return [];
        }

        return $data;
    }
}
