<?php

namespace Dalten\RuianToUir\Converter;

use Dalten\RuianToUir\Converter\Field\PointCoordinatesConverter;

/**
 * Převaděč na entitu části obce.
 */
class MunicipalityPart extends AbstractConverter implements ConverterInterface
{
    /**
     * Nastavuje konfiguraci třídy.
     *
     * @param PointCoordinatesConverter $coordinateConverter
     */
    public function __construct(PointCoordinatesConverter $coordinateConverter)
    {
        parent::__construct($coordinateConverter);
        $this->_handledTag = 'vf:CastObce';
    }

    /**
     * {@inheritdoc}
     */
    public function convert(\XMLReader $document)
    {
        $data = ['stav' => 1];
        while ($this->_getNextElement($document)) {
            switch ($document->name) {
                case 'coi:Kod':
                    $data['cobce_kod'] = (int) $document->readString();

                    break;
                case 'coi:Nazev':
                    $data['zkratka'] = $data['nazev'] = (string) $document->readString();

                    break;
                case 'coi:Obec':
                    if (!$document->isEmptyElement) {
                        $this->_getNextElement($document);
                        if ('obi:Kod' === $document->name) {
                            $data['obec_kod'] = (int) $document->readString();
                        }
                    }

                    break;
                case 'coi:Geometrie':
                    if (!$document->isEmptyElement) {
                        $data['geom'] = $this->_getGeometryData($document);
                    }

                    break;
                default:
                    $this->_skipToElementEnd($document);

                    break;
            }
        }

        return $data;
    }
}
