<?php

namespace Dalten\RuianToUir\Writer;

/**
 * Formatter, který vypisuje data do výstupní šložky jako soubory, pojmenované dle converteru, který data přeložil.
 */
class MultipleFiles extends AbstractWriter implements WriterInterface
{
    /**
     * Cesta k cílovému adresáři.
     *
     * @var string
     */
    private $_dirName;

    /**
     * Příponatvořených souborů.
     *
     * @var string
     */
    private $_extension;

    /**
     * Nastavuje závilosti a konfiguraci.
     *
     * @param \Dalten\RuianToUir\Formatter\FormatterInterface $formatter Instance formatteru.
     * @param string                                          $dirName   Název cílového adresáře.
     * @param string                                          $extension Přípona tvořených souborů (bez tečky).
     */
    public function __construct(\Dalten\RuianToUir\Formatter\FormatterInterface $formatter, $dirName,
        $extension = 'txt')
    {
        $this->_dirName = $dirName;
        $this->_extension = $extension;
        parent::__construct($formatter);
    }

    /**
     * Zapíše data do souboru dle názvu converteru.
     *
     * @param string $data          Zformátovaná data.
     * @param string $converterName Název converteru, který provedl převod.
     *
     * @throws \RuntimeException Pokud se nepodaří zápis do souboru.
     */
    protected function _write($data, $converterName)
    {
        $fileName = $this->_getFileName($converterName);
        $result = file_put_contents($fileName, $data.PHP_EOL, FILE_APPEND);
        if (false === $result) {
            throw new \RuntimeException(sprintf('Nepodařil se zápis do souboru %s!', $fileName));
        }
    }

    /**
     * Převede název converteru na cestu k souboru.
     *
     * @param string $converterName Název converteru, který provedl převod.
     *
     * @return string Cesta k cílovému souboru.
     */
    private function _getFileName($converterName)
    {
        $name = $this->_dirName.DIRECTORY_SEPARATOR.$converterName;
        if ($this->_extension) {
            $name .= '.'.$this->_extension;
        }

        return $name;
    }
}
