-- Vytvoří a naplní tabulku "vazba"
-- Není potřeba pro RUIAN, ale je potřeba pro kompatibilitu s UIR

CREATE TABLE IF NOT EXISTS `vazba` (
	`vazba_id`  INT(11)       NOT NULL AUTO_INCREMENT,
	`mcast_kod` INT(11)                DEFAULT NULL,
	`cobce_kod` INT(11)       NOT NULL DEFAULT '0',
	`ulice_kod` INT(11)                DEFAULT NULL,
	`psc`       DECIMAL(5, 0) NOT NULL DEFAULT '0',
	PRIMARY KEY (`vazba_id`),
	UNIQUE KEY `principal` (`mcast_kod`, `cobce_kod`, `ulice_kod`),
	KEY `mcast_kod` (`mcast_kod`),
	KEY `cobce_kod` (`cobce_kod`),
	KEY `ulice_kod` (`ulice_kod`)
) ENGINE = MyISAM
	DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- RUIAN - vytvoření vazby

TRUNCATE `vazba`;
INSERT IGNORE INTO vazba
	SELECT
		NULL,
		IF(o.`mcast_kod` IS NULL, 0, o.`mcast_kod`),
		IFNULL(o.`cobce_kod`, 0),
		IF(a.`ulice_kod` IS NULL, 0, a.`ulice_kod`),
		a.`psc`
	FROM `objekt` o LEFT JOIN `adresa` a ON (o.`objekt_kod` = a.`objekt_kod`);

-- Doplnění helptextů pro Irest/Maxis

UPDATE obec
SET helptext=(
	SELECT CONCAT("okres: ", okres.nazev)
	FROM okres
	WHERE obec.okres_kod=okres.okres_kod
);

UPDATE cobce
SET helptext=(
	SELECT CONCAT("obec: ", obec.nazev, ", ok.: ", okres.nazev)
	FROM obec
	INNER JOIN okres ON okres.okres_kod=obec.okres_kod
	WHERE cobce.obec_kod=obec.obec_kod
);

UPDATE mcast
SET helptext=(
	SELECT CONCAT("obec: ", obec.nazev, ", ok.: ", okres.nazev)
	FROM obec
	INNER JOIN okres ON okres.okres_kod=obec.okres_kod
	WHERE mcast.obec_kod=obec.obec_kod
);

UPDATE pobvod
SET helptext=(
	SELECT CONCAT("obec: ", obec.nazev, ", ok.: ", okres.nazev)
	FROM obec
	INNER JOIN okres ON okres.okres_kod=obec.okres_kod
	WHERE pobvod.obec_kod=obec.obec_kod
);

UPDATE ulice
SET helptext=(
	SELECT CONCAT("obec: ", obec.nazev, ", ok.: ", okres.nazev)
	FROM obec
	INNER JOIN okres ON okres.okres_kod=obec.okres_kod
	WHERE ulice.obec_kod=obec.obec_kod
);
-- Přidání tabulky pro reality.cz

CREATE TABLE IF NOT EXISTS `realitycz_cobce2ku` (
	`cobce_kod` INT(11)       UNSIGNED NOT NULL DEFAULT '0',
	`nazev`     varchar(250)  CHARACTER SET utf8 COLLATE utf8_czech_ci DEFAULT NULL,
	`ku_kod`    INT(11)       UNSIGNED NOT NULL DEFAULT '0',
	`obec_kod`  INT(11)       UNSIGNED NOT NULL DEFAULT '0',
	`ambiguous`  TINYINT(4)   UNSIGNED NOT NULL DEFAULT '0',
	PRIMARY KEY (`cobce_kod`)
) ENGINE = InnoDB
	DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

TRUNCATE `realitycz_cobce2ku`;
INSERT INTO `realitycz_cobce2ku`
SELECT cobce.cobce_kod, cobce.nazev, katastralni_uzemi.ku_kod, cobce.obec_kod, IF(count(*) > 1, 1, 0)
FROM objekt
	     INNER JOIN cobce ON cobce.cobce_kod = objekt.cobce_kod
	     INNER JOIN parcela ON (parcela.parcela_kod = objekt.parcela_kod)
	     INNER JOIN katastralni_uzemi ON (parcela.ku_kod = katastralni_uzemi.ku_kod)
GROUP BY cobce.cobce_kod;
