<?php

namespace Dalten\RuianToUir\Converter;

use Dalten\RuianToUir\Converter\Field\PointCoordinatesConverter;

/**
 * Převaděč na entitu katastrálního území.
 */
class CadastralArea extends AbstractConverter implements ConverterInterface
{
    /**
     * Nastavuje konfiguraci třídy.
     *
     * @param PointCoordinatesConverter $coordinateConverter
     */
    public function __construct(PointCoordinatesConverter $coordinateConverter)
    {
        parent::__construct($coordinateConverter);
        $this->_handledTag = 'vf:KatastralniUzemi';
    }

    /**
     * {@inheritdoc}
     */
    public function convert(\XMLReader $document)
    {
        $element = $this->_getNextElement($document);

        if ($element instanceof \XMLReader && $element->name === $this->_handledTag) {
            // pokud jsme narazili na tag ku, který obsahuje další ku, zpracujeme to a tuhle přeskočíme
            $this->_getNextElement($document);
        }
        $data = ['stav' => 1];
        do {
            switch ($document->name) {
                case 'kui:Kod':
                    $data['ku_kod'] = (int) $document->readString();

                    break;
                case 'kui:Nazev':
                    $data['nazev'] = (string) $document->readString();

                    break;
                case 'kui:Obec':
                    if (!$document->isEmptyElement) {
                        $this->_getNextElement($document);
                        if ('obi:Kod' === $document->name) {
                            $data['obec_kod'] = (int) $document->readString();
                        }
                    }

                    break;
                case 'kui:Geometrie':
                    if (!$document->isEmptyElement) {
                        $data['geom'] = $this->_getGeometryData($document);
                    }

                    break;
                default:
                    $this->_skipToElementEnd($document);

                    break;
            }
        } while ($this->_getNextElement($document));

        return $data;
    }
}
