<?php

namespace Dalten\RuianToUir\Converter;

use Dalten\RuianToUir\Converter\Field\PointCoordinatesConverter;

/**
 * Převaděč na entitu městské části.
 */
class CityPart extends AbstractConverter implements ConverterInterface
{
    /**
     * Nastavuje konfiguraci třídy.
     *
     * @param PointCoordinatesConverter $coordinateConverter
     */
    public function __construct(PointCoordinatesConverter $coordinateConverter)
    {
        parent::__construct($coordinateConverter);
        $this->_handledTag = 'vf:Momc';
    }

    /**
     * Převádí informace z prvku pod kurzorem do formátu UIR.
     *
     * Protože RUIAN vkládá elementy části obce do sebe, zkusí tato třída zda daný prvek neobsahuje další podobný.
     * Pokud ano, pak zpracuje až vnitřní prvek. Bohužel je toto při přáci s XMLReaderem nutnost.
     *
     * @param \XMLReader $document Instance readeru s kurzorem na testovaném prvku.
     *
     * @return array Pole s daty ve formátu UIR.
     */
    public function convert(\XMLReader $document)
    {
        $data = ['stav' => 1];

        $element = $this->_getNextElement($document);

        if ($element instanceof \XMLReader && $element->name === $this->_handledTag) {
            // pokud jsme narazili na tag mčásti, který obsahuje další mčást, zpracujeme tu a tuhle přeskočíme
            $this->_getNextElement($document);
        }

        do {
            switch ($document->name) {
                case 'mci:Kod':
                    $data['mcast_kod'] = (int) $document->readString();

                    break;
                case 'mci:Nazev':
                    $data['zkratka'] = $data['nazev'] = (string) $document->readString();

                    break;
                case 'mci:Obec':
                    if (!$document->isEmptyElement) {
                        $this->_getNextElement($document);
                        if ('obi:Kod' === $document->name) {
                            $data['obec_kod'] = (int) $document->readString();
                        }
                    }

                    break;
                case 'mci:SpravniObvod':
                    if (!$document->isEmptyElement) {
                        $this->_getNextElement($document);
                        if ('spi:Kod' === $document->name) {
                            $data['sobvod_kod'] = (int) $document->readString();
                        }
                    }

                    break;
                case 'mci:Mop':
                    if (!$document->isEmptyElement) {
                        $this->_getNextElement($document);
                        if ('mpi:Kod' === $document->name) {
                            $data['pobvod_kod'] = (int) $document->readString();
                        }
                    }

                    break;
                case 'mci:Geometrie':
                    if (!$document->isEmptyElement) {
                        $data['geom'] = $this->_getGeometryData($document);
                    }

                    break;
                default:
                    $this->_skipToElementEnd($document);

                    break;
            }
        } while ($this->_getNextElement($document));

        return $data;
    }
}
