<?php

namespace Dalten\RuianToUir\Converter;

use Dalten\RuianToUir\Converter\Field\PointCoordinatesConverter;

/**
 * Převaděč na entitu pražského obvodu.
 */
class PragueDistrict extends AbstractConverter implements ConverterInterface
{
    /**
     * Nastavuje konfiguraci třídy.
     *
     * @param PointCoordinatesConverter $coordinateConverter
     */
    public function __construct(PointCoordinatesConverter $coordinateConverter)
    {
        parent::__construct($coordinateConverter);
        $this->_handledTag = 'vf:Mop';
    }

    /**
     * {@inheritdoc}
     */
    public function convert(\XMLReader $document)
    {
        $element = $this->_getNextElement($document);

        if ($element instanceof \XMLReader && $element->name === $this->_handledTag) {
            // pokud jsme narazili na handled tag, obsahující jiný handled tag, tak zpracujeme ten vnitřní
            $this->_getNextElement($document);
        }

        $data = ['stav' => 1];
        do {
            switch ($document->name) {
                case 'mpi:Kod':
                    $data['pobvod_kod'] = (int) $document->readString();

                    break;
                case 'mpi:Nazev':
                    $data['zkratka'] = $data['nazev'] = $document->readString();

                    break;
                case 'mpi:Obec':
                    if (!$document->isEmptyElement) {
                        $this->_getNextElement($document);
                        if ('obi:Kod' === $document->name) {
                            $data['obec_kod'] = (int) $document->readString();
                        }
                    }

                    break;
                case 'mpi:Geometrie':
                    if (!$document->isEmptyElement) {
                        $data['geom'] = $this->_getGeometryData($document);
                    }

                    break;
                default:
                    $this->_skipToElementEnd($document);

                    break;
            }
        } while ($this->_getNextElement($document));

        return $data;
    }
}
