<?php

namespace Dalten\RuianToUir\Writer;

/**
 * Abstraktní writer - zapouzdřuje společnou funkcionalitu jednotlivých writerů.
 */
abstract class AbstractWriter implements WriterInterface
{
    /**
     * Formatter, který bude použit na převod dat.
     *
     * @var \Dalten\RuianToUir\Formatter\FormatterInterface
     */
    private $_formatter;

    /**
     * Nastavuje formatter.
     *
     * @param \Dalten\RuianToUir\Formatter\FormatterInterface $formatter Formatter, který bude použit na převod dat.
     */
    public function __construct(\Dalten\RuianToUir\Formatter\FormatterInterface $formatter)
    {
        $this->_formatter = $formatter;
    }

    /**
     * Zapíše data (dle konkrétní implementace).
     *
     * @param array  $data          Pole převedených dat.
     * @param string $converterName Název converteru, který provedl převod.
     */
    public function write($data, $converterName)
    {
        $this->_write($this->_formatter->format($data, $converterName), $converterName);
    }

    /**
     * Metoda, kterou přepisují potomkové. Dostane již zformátovaná data a obstarává vlastní zápis.
     *
     * @param string $data          Zformátovaná data.
     * @param string $converterName Název converteru, který provedl převod.
     */
    abstract protected function _write($data, $converterName);
}
