<?php

namespace Dalten\RuianToUir\Converter\Field;

class Point extends GeometryField implements GeometryFieldInterface
{
    /** Oddělovač souřadnic. */
    const LAT_LNG_SPLITTER = ' ';

    /** Typ prvku - bod. */
    const TYPE = 'Point';

    /**
     * Point constructor.
     *
     * @param string $inputString Souřadnice v WGS (GPS) formátu.
     */
    public function __construct($inputString)
    {
        $geometrie = [];
        if (!empty($inputString)) {
            $tmp = explode(self::LAT_LNG_SPLITTER, $inputString);

            $geometrie = [
                [
                    'lat' => $tmp[0],
                    'lng' => $tmp[1],
                ],
            ];
        }

        // Rovnou převedeme do WGS84
        parent::__construct(self::TYPE, $geometrie);
    }

    /**
     * Vrátí textovou reprezentaci pole.
     *
     * Implementace této metody je nutná kvůli zachování BC s původním formátem (=string). Jednotlivé formattery
     * samozřejmě mohou typehintovat konkrétní Field a zpracovávat ho odlišně. Ale tímto zajistíme že se nic omylem
     * nerozbije.
     *
     * @return string Textová reprezentace pole.
     */
    public function __toString()
    {
        return $this->getWKT();
    }
}
