<?php

namespace Dalten\RuianToUir\Converter\Result;

/**
 * Created by PhpStorm.
 * User: karel
 * Date: 16.03.2017
 * Time: 11:47.
 */
class CodebookItem
{
    /** @var string Název číselníku. */
    private $codebookName;

    /** @var string Hodnota položky. */
    private $value;

    /** @var string Název položky. */
    private $label;

    /** @var bool Je položka platná? */
    private $isValid;

    /**
     * CodebookItem constructor.
     *
     * @param string $codebookName Název číselníku.
     * @param string $value        Hodnota položky.
     * @param string $label        Název položky.
     * @param bool   $isValid      Je položka platná?
     */
    public function __construct($codebookName, $value, $label, $isValid = true)
    {
        $this->codebookName = trim($codebookName);
        $this->value = trim($value);
        $this->label = trim($label);
        $this->isValid = (bool) $isValid;
    }

    /**
     * @return string Název číselníku.
     */
    public function getCodebookName()
    {
        return $this->codebookName;
    }

    /**
     * @return string Hodnota položky.
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @return string Název položky.
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * @return bool Je položka platná?
     */
    public function isValid()
    {
        return $this->isValid;
    }
}
