<?php

namespace Dalten\RuianToUir\Converter;

use Dalten\RuianToUir\Converter\Field\PointCoordinatesConverter;

/**
 * Převaděč na entitu městské ulice.
 */
class Street extends AbstractConverter implements ConverterInterface
{
    /**
     * Nastavuje konfiguraci třídy.
     *
     * @param PointCoordinatesConverter $coordinateConverter
     */
    public function __construct(PointCoordinatesConverter $coordinateConverter)
    {
        parent::__construct($coordinateConverter);
        $this->_handledTag = 'vf:Ulice';
    }

    /**
     * Převádí informace z prvku pod kurzorem do formátu UIR.
     *
     * Protože RUIAN vkládá elementy ulice do sebe, zkusí tato třída zda daný prvek neobsahuje další podobný.
     * Pokud ano, pak zpracuje až vnitřní prvek. Bohužel je toto při přáci s XMLReaderem nutnost.
     *
     * @param \XMLReader $document Instance readeru s kurzorem na testovaném prvku.
     *
     * @return array Pole s daty ve formátu UIR.
     */
    public function convert(\XMLReader $document)
    {
        $data = ['stav' => 1];

        $element = $this->_getNextElement($document);

        if ($element instanceof \XMLReader && $element->name === $this->_handledTag) {
            // pokud jsme narazili na tag ulice, který obsahuje další ulici, zpracujeme tu a tuhle přeskočíme
            $this->_getNextElement($document);
        }

        do {
            switch ($document->name) {
                case 'uli:Kod':
                    $data['ulice_kod'] = (int) $document->readString();

                    break;
                case 'uli:Nazev':
                    $data['zkratka'] = $data['nazev'] = (string) $document->readString();

                    break;
                case 'uli:Obec':
                    if (!$document->isEmptyElement) {
                        $this->_getNextElement($document);
                        if ('obi:Kod' === $document->name) {
                            $data['obec_kod'] = (int) $document->readString();
                        }
                    }

                    break;
                default:
                    $this->_skipToElementEnd($document);

                    break;
            }
        } while ($this->_getNextElement($document));

        return $data;
    }
}
