![image](/uploads/b3d8f945631b57b9fd21c22c7e355439/image.png)

Ruian2UirConverter
==================

Knihovna, sloužící k převádění dat ve formátu RUIAN do formátu kompatibilního s UIR.

Dokumentace RUIAN se nachází v [doc/RUIAN.md](doc/RUIAN.md)

## Instalace
Knihovna využívá několik symfony komponent a instaluje se přes composer.

`composer install`

## Stažení souborů
Pro získání url k Ruian datům použijeme následující příkaz:

`php console get-file-list full > links.txt`

(Kompletní dokumentace k `get-file-list` je níže. Možná nebude nutné stahovat všechny soubory.)

Nyní tyto data potřebujeme stáhnout. Idealní je na Linuxu příkaz wget (vezme URL adresy ze souboru links.txt a stáhne data na těchto adresách do adresáře ./data)

`xargs -i wget '{}' -P data  < links.txt`

Nyní potřebujeme tato data rozbalit:

`gunzip -d ./data/* `


## Použití
Knihovna vystupuje jako několik symfony commandů.

Nápovědu ke každému commandu (včetně jeho parametrů) je možné získat klasicky pomocí:

`php console help command_name`

### convert
Převede xml soubor z RUIANu na jeho UIR ekvivalent.

Není možné převádět 1:1 (tj. například vytvářet tabulku `vazba`), ale snažíme se co se dá.

Argument `[cesta_k_souboru]` může být adresář (`./data`), soubor (`data/input.xml`) nebo maska (`data/*.xml`).

`php console convert [cesta_k_souboru]`

### explore
Převede xml soubor RUIAN na jednoduchou reprezentaci jeho schématu.

V podstatě se pokusí najít v XML jednoho zástupce každého druhu prvku a převede jej na pole, které vypíše jako strom. Vzhledem k náhodnému výběru prvku je nutno brát výsledky s rezervou.

Argument `[cesta_k_souboru]` může být adresář (`./data`), soubor (`data/input.xml`) nebo maska (`data/*.xml`).

`php console explore [cesta_k_souboru]`

### get-file-list
Získá z RUIANu seznam souborů, které je potřeba stáhnout.

Argument `[typ souborů]` může být adresář `full` (vytvoří seznam souborů pro kompletní datovou sadu = hodně souborů) a nebo `diff` (stáhne změnové soubory od `--from-date`).

`--from-date` je ve formátu `YYYY-mm-dd`. Podporován je i formát `dd.mm.YYYY` (01.01.2011), ale ten je deprecated (kvůli změnám na straně ruian) a bude ve v2 odstraněn.

`php console get-file-list [typ souborů] [--from-date=01.01.2011]`

### get-codebooks
Převede xml s číselníky RUIAN do textového nebo YAML formátu.

Argument `cesta_k_souboru` je nepovinný. Pokud není předán, pak budou stažena aktuální data přímo z RUIANu. Pokud uveden je, musí se jednat o cestu k existujícímu souboru s číselníky.

`php console get-codebooks [cesta_k_souboru]`
