<?php

namespace Dalten\RuianToUir\Converter;

use Dalten\RuianToUir\Converter\Field\PointCoordinatesConverter;

/**
 * Převaděč na entitu objektu.
 */
class Building extends AbstractConverter implements ConverterInterface
{
    /**
     * Nastavuje konfiguraci třídy.
     *
     * @param PointCoordinatesConverter $coordinateConverter
     */
    public function __construct(PointCoordinatesConverter $coordinateConverter)
    {
        parent::__construct($coordinateConverter);
        $this->_handledTag = 'vf:StavebniObjekt';
    }

    /**
     * {@inheritdoc}
     */
    public function convert(\XMLReader $document)
    {
        $data = ['stav' => 1];
        while ($this->_getNextElement($document)) {
            switch ($document->name) {
                case 'soi:Kod':
                    $data['objekt_kod'] = (int) $document->readString();

                    break;
                case 'soi:CislaDomovni':
                    if (!$document->isEmptyElement) {
                        // pozn.: Zde může být váce prvků než jeden. Zatím ale bereme vždy jen první.
                        // pro každé ČP zde bude existovat i odpovídající adresní bod (alespoň jeden)
                        // z tohoto pravidla může teoreticky existovat výjimka, ale pro nás snad nebude podstatná
                        $this->_getNextElement($document);
                        if ('com:CisloDomovni' === $document->name) {
                            $data['cisdom_hod'] = (int) $document->readString();
                        }
                    }

                    break;
                case 'soi:CastObce':
                    if (!$document->isEmptyElement) {
                        $this->_getNextElement($document);
                        if ('coi:Kod' === $document->name) {
                            $data['cobce_kod'] = (int) $document->readString();
                        }
                    }

                    break;
                case 'soi:Momc':
                    if (!$document->isEmptyElement) {
                        $this->_getNextElement($document);
                        if ('mci:Kod' === $document->name) {
                            $data['mcast_kod'] = (int) $document->readString();
                        }
                    }

                    break;
                case 'soi:IdentifikacniParcela':
                    if (!$document->isEmptyElement) {
                        $this->_getNextElement($document);
                        if ('pai:Id' === $document->name) {
                            $data['parcela_kod'] = (int) $document->readString();
                        }
                    }

                    break;

                case 'soi:Geometrie':
                    if (!$document->isEmptyElement) {
                        $data['geom'] = $this->_getGeometryData($document);
                    }

                    break;
                case 'soi:Dokonceni':
                    $data['datum_dokonceni'] = preg_replace('/T.*/', '', $document->readString());

                    break;
                case 'soi:DruhKonstrukceKod':
                    $data['druh_konstrukce'] = (int) $document->readString();

                    break;
                case 'soi:ObestavenyProstor':
                    $data['obestaveny_prostor'] = (int) $document->readString();

                    break;
                case 'soi:PocetBytu':
                    $data['pocet_bytu'] = (int) $document->readString();

                    break;
                case 'soi:PocetPodlazi':
                    $data['pocet_podlazi'] = (int) $document->readString();

                    break;
                case 'soi:PodlahovaPlocha':
                    $data['plocha_podlahova'] = (int) $document->readString();

                    break;
                case 'soi:ZastavenaPlocha':
                    $data['plocha_zastavena'] = (int) $document->readString();

                    break;
                case 'soi:PripojeniKanalizaceKod':
                    $data['pripojeni_kanalizace'] = (int) $document->readString();

                    break;
                case 'soi:PripojeniPlynKod':
                    $data['pripojeni_plyn'] = (int) $document->readString();

                    break;
                case 'soi:PripojeniVodovodKod':
                    $data['pripojeni_vodovod'] = (int) $document->readString();

                    break;
                case 'soi:VybaveniVytahemKod':
                    $data['vytah'] = (int) $document->readString();

                    break;
                case 'soi:ZpusobVytapeniKod':
                    $data['zpusob_vytapeni'] = (int) $document->readString();

                    break;
                case 'soi:TypStavebnihoObjektuKod':
                    $data['cisdom_typ'] = (int) $document->readString();

                    break;
                case 'soi:ZpusobVyuzitiKod':
                    $data['zpusob_vyuziti'] = (int) $document->readString();

                    break;
                default:
                    $this->_skipToElementEnd($document);

                    break;
            }
        }

        return $data;
    }
}
