<?php

namespace Dalten\RuianToUir\Converter\Result;

/**
 * Created by PhpStorm.
 * User: karel
 * Date: 22.02.2017
 * Time: 11:51.
 */
class RemoveRecord implements ResultInterface
{
    /**
     * @var string
     */
    private $itemType;
    /**
     * @var string
     */
    private $identifier;

    /**
     * RemoveRecord constructor.
     *
     * @param string $itemType   Typ záznamu (County, Region, Address, ...).
     * @param string $identifier Identifikátor (kód) záznamu.
     */
    public function __construct($itemType, $identifier)
    {
        $this->itemType = $itemType;
        $this->identifier = $identifier;
    }

    /** {@inheritdoc} */
    public function getData()
    {
        return [];
    }

    /** {@inheritdoc} */
    public function getItemType()
    {
        return $this->itemType;
    }

    /** {@inheritdoc} */
    public function getActionType()
    {
        return ResultInterface::ACTION_TYPE_REMOVE_RECORD;
    }

    /** {@inheritdoc} */
    public function getIdentifier()
    {
        return $this->identifier;
    }
}
