<?php

namespace Dalten\RuianToUir\Converter\Field;

use proj4php\Proj;
use proj4php\Proj4php;

class PointCoordinatesConverter
{
    /**
     * @var Proj4php
     */
    private $_converter;
    /**
     * @var Proj
     */
    private $_sourceProjection;
    /**
     * @var Proj
     */
    private $_targetProjection;

    /**
     * PointCoordinatesConverter constructor.
     *
     * @param Proj4php $converter
     * @param Proj     $sourceProjection
     * @param Proj     $targetProjection
     */
    public function __construct(Proj4php $converter, Proj $sourceProjection, Proj $targetProjection)
    {
        $this->_converter = $converter;
        $this->_sourceProjection = $sourceProjection;
        $this->_targetProjection = $targetProjection;
    }

    public function convertCoords($ruianCoordinates)
    {
        $coords = explode(' ', $ruianCoordinates);
        // EPSG:5514 má oproti WGS84 prohozené osy X a Y
        $source = new \proj4php\Point($coords[1], $coords[0], null, $this->_sourceProjection);

        return $this->_converter->transform($this->_targetProjection, $source)->toShortString();
    }
}
