<?php

namespace Dalten\RuianToUir\Command\Helper;

use Composer\CaBundle\CaBundle;

class FileDownloader
{
    /**
     * Vrátí první řádku ze souboru na uri.
     *
     * @param string $uri Uri k souboru.
     *
     * @return string První řádka souboru na $uri.
     */
    public function getFirstLineFromFile($uri)
    {
        $data = $this->getFile($uri);
        if (is_string($data) && $data) {
            return trim((string) (strtok($data, "\n")));
        }

        throw new \RuntimeException(sprintf('Nepodařilo se stáhnout soubor "%s"', $uri));
    }

    /**
     * @param string $uri Uri k souboru.
     *
     * @return string|bool Obsah souboru na $uri (false pokud nejde stáhnout).
     */
    public function getFile($uri)
    {
        $curl = curl_init($uri);
        if ($curl) {
            curl_setopt($curl, CURLOPT_CAINFO, CaBundle::getBundledCaBundlePath());
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

            return curl_exec($curl);
        }

        return false;
    }

    /**
     * Stáhne soubor na dané URI a následně jej nzipne a vrátí cestu k novému souboru.
     *
     * Smazání předaného souboru je starostí volajícího skriptu.
     *
     * @param string $uri Uri k souboru.
     *
     * @return string Cesta ke staženému souboru.
     */
    public function downloadAndGunzipFileToTemp($uri)
    {
        $curl = curl_init($uri);
        $compressedFilePath = null;
        if ($curl) {
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            $compressedFilePath = tempnam(sys_get_temp_dir(), 'ruian2uir.xml.zip');
            if ($compressedFilePath) {
                $fp = fopen($compressedFilePath, 'w');
                if ($fp) {
                    curl_setopt($curl, CURLOPT_FILE, $fp);
                    curl_exec($curl);
                    curl_close($curl);
                    fclose($fp);
                }
            }
        }

        if (!$curl || empty($compressedFilePath) || !file_exists($compressedFilePath)) {
            throw new \RuntimeException(sprintf('Nepodařilo se stáhnout "%s" do "%s"!', $uri, $compressedFilePath));
        }

        $unzipTarget = tempnam(sys_get_temp_dir(), 'ruian2uir.xml');

        $zip = new \ZipArchive();
        $result = false;
        if ($unzipTarget && $zip->open($compressedFilePath)) {
            $fileName = $zip->getNameIndex(0);
            $zip->close();
            $result = copy('zip://'.$compressedFilePath.'#'.$fileName, $unzipTarget);
        }
        if (!$result) {
            throw new \RuntimeException(
                sprintf('Nepodařilo se rozbalit soubor "%s" do "%s"!', $compressedFilePath, $unzipTarget)
            );
        }
        unlink($compressedFilePath);

        return (string) $unzipTarget;
    }
}
