<?php

namespace Dalten\RuianToUir\Converter;

use Dalten\RuianToUir\Converter\Field\PointCoordinatesConverter;

/**
 * Převaděč na entitu kraje.
 */
class County extends AbstractConverter implements ConverterInterface
{
    /**
     * Nastavuje konfiguraci třídy.
     *
     * @param PointCoordinatesConverter $coordinateConverter
     */
    public function __construct(PointCoordinatesConverter $coordinateConverter)
    {
        parent::__construct($coordinateConverter);
        $this->_handledTag = 'vf:Vusc';
    }

    /**
     * {@inheritdoc}
     */
    public function convert(\XMLReader $document)
    {
        $element = $this->_getNextElement($document);

        if ($element instanceof \XMLReader && $element->name === $this->_handledTag) {
            // pokud jsme narazili na tag mčásti, který obsahuje další mčást, zpracujeme tu a tuhle přeskočíme
            $this->_getNextElement($document);
        }
        $data = ['stav' => 1];
        do {
            switch ($document->name) {
                case 'vci:Kod':
                    $data['kraj_kod'] = (int) $document->readString();

                    break;
                case 'vci:Nazev':
                    $data['zkratka'] = $data['nazev'] = (string) $document->readString();

                    break;
                case 'vci:NutsLau':
                    $data['nuts3'] = (string) $document->readString();

                    break;
                case 'vci:Geometrie':
                    if (!$document->isEmptyElement) {
                        $data['geom'] = $this->_getGeometryData($document);
                    }

                    break;
                default:
                    $this->_skipToElementEnd($document);

                    break;
            }
        } while ($this->_getNextElement($document));

        return $data;
    }
}
