<?php

namespace Dalten\RuianToUir\Converter\Field;

class GeometryField
{
    /** @var string Typ prvku. */
    private $type;

    /** @var string String vhodný pro použití v MySQL funkci ST_GeomFromText(...) */
    private $wkt;

    /**
     * GeometryField constructor.
     *
     * @param string $type   Typ prvku.
     * @param array  $coords Pole souřadnic v GPS. [['lat' => 0, 'lon' => 0], ...]
     */
    public function __construct($type, $coords)
    {
        $this->type = $type;
        $this->wkt = $this->buildWKT($coords);
    }

    /**
     * Vrátí WKT vhodný pro SQL INSERT.
     *
     * @return string
     */
    public function getWKT()
    {
        return $this->wkt;
    }

    /**
     * Získá typ geometrie.
     *
     * @return string
     */
    protected function getType()
    {
        return $this->type;
    }

    /**
     * Vytvoří SQL INSERT ve WKT formátu pro geometrii.
     *
     * Vrací string ve WKT formátu geometrie
     *
     * @var array Pole souřadnic v GPS. [['lat' => 0, 'lon' => 0], ...]
     *
     * @return string
     */
    protected function buildWKT(array $coords)
    {
        // $wkt je string, který bude fungovat, jako output
        $wkt = '';

        if (!empty($coords)) {
            $lastElement = count($coords);
            $count = 0;
            $wkt = $this->getType();
            $wkt .= '(';

            foreach ($coords as $coord) {
                if (++$count === $lastElement) {
                    $wkt .= $coord['lat'].' '.$coord['lng'];
                } else {
                    $wkt .= $coord['lat'].' '.$coord['lng'].', ';
                }
            }

            $wkt .= ')';
        }

        return $wkt;
    }
}
