<?php

namespace Dalten\RuianToUir\Converter;

use Dalten\RuianToUir\Converter\Field\PointCoordinatesConverter;

/**
 * Převaděč na entitu obce.
 */
class Municipality extends AbstractConverter implements ConverterInterface
{
    /**
     * Nastavuje konfiguraci třídy.
     *
     * @param PointCoordinatesConverter $coordinateConverter
     */
    public function __construct(PointCoordinatesConverter $coordinateConverter)
    {
        parent::__construct($coordinateConverter);
        $this->_handledTag = 'vf:Obec';
    }

    /**
     * {@inheritdoc}
     */
    public function convert(\XMLReader $document)
    {
        $data = ['stav' => 1];
        while ($this->_getNextElement($document)) {
            switch ($document->name) {
                case 'obi:Kod':
                    $data['obec_kod'] = (int) $document->readString();

                    break;
                case 'obi:Nazev':
                    $data['zkratka'] = $data['nazev'] = (string) $document->readString();

                    break;
                case 'obi:StatusKod':
                    $data['typ_obce'] = (int) $document->readString();

                    break;
                case 'obi:NutsLau':
                    $data['nuts5'] = $document->readString();

                    break;
                case 'obi:Okres':
                    if (!$document->isEmptyElement) {
                        $this->_getNextElement($document);
                        if ('oki:Kod' === $document->name) {
                            $data['okres_kod'] = (int) $document->readString();
                        }
                    }

                    break;
                case 'obi:Pou':
                    if (!$document->isEmptyElement) {
                        $this->_getNextElement($document);
                        if ('pui:Kod' === $document->name) {
                            $data['pou_kod'] = (int) $document->readString();
                        }
                    }

                    break;
                case 'obi:Geometrie':
                    if (!$document->isEmptyElement) {
                        $data['geom'] = $this->_getGeometryData($document);
                    }

                    break;
                default:
                    $this->_skipToElementEnd($document);

                    break;
            }
        }

        return $data;
    }
}
