<?php

namespace Dalten\RuianToUir\Converter;

/**
 * Rozhraní pro jednotlivé převaděče.
 */
interface ConverterInterface
{
    /**
     * Zjišťuje, zda tato třída dokáže obsloužit daný element.
     *
     * @param \XMLReader $document Instance readeru s kurzorem na testovaném prvku.
     *
     * @return bool Obsluhuje tato třída daný prvek?
     */
    public function accepts(\XMLReader $document);

    /**
     * Převádí informace z prvku pod kurzorem do formátu UIR.
     *
     * @param \XMLReader $document Instance readeru s kurzorem na testovaném prvku.
     *
     * @return array Pole s daty ve formátu UIR.
     */
    public function convert(\XMLReader $document);

    /**
     * Vrátí název converteru.
     *
     * @return string Název converteru.
     */
    public function getName();
}
