<?php

namespace Dalten\RuianToUir\Converter\Result;

/**
 * Created by PhpStorm.
 * User: karel
 * Date: 22.02.2017
 * Time: 11:51.
 */
class AddRecord implements ResultInterface
{
    /** @var array */
    private $data = [];
    /**
     * @var string
     */
    private $itemType;
    /**
     * @var string
     */
    private $identifier;

    /**
     * AddRecord constructor.
     *
     * @param string $itemType   Typ záznamu (County, Region, Address, ...).
     * @param string $identifier Identifikátor (kód) záznamu.
     * @param array  $data       Data záznamu.
     */
    public function __construct($itemType, $identifier, array $data)
    {
        $this->data = $data;
        $this->itemType = $itemType;
        $this->identifier = $identifier;
    }

    /** {@inheritdoc} */
    public function getData()
    {
        return $this->data;
    }

    /** {@inheritdoc} */
    public function getItemType()
    {
        return $this->itemType;
    }

    /** {@inheritdoc} */
    public function getActionType()
    {
        return ResultInterface::ACTION_TYPE_ADD_RECORD;
    }

    /** {@inheritdoc} */
    public function getIdentifier()
    {
        return $this->identifier;
    }
}
