<?php

namespace Dalten\RuianToUir\DependencyInjection;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;

/**
 * Class RuianToUirExtension.
 */
class RuianToUirExtension extends Extension
{
    /**
     * Loads a specific configuration.
     *
     * @param array            $configs
     * @param ContainerBuilder $container
     *
     * @throws \Exception
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $loader = new YamlFileLoader($container, new FileLocator(__DIR__.'/../../config'));
        $loader->load('services.yml');
        $container->setParameter(
            'ruian_to_uir.database_structure_definition', __DIR__.'/../../datovy_model.sql'
        );
        $container->setParameter(
            'ruian_to_uir.uir_compatibility_definition', __DIR__.'/../../uir-compat.sql'
        );
        $container->setParameter(
            'ruian_to_uir.country_list_definition', __DIR__.'/../../stat.sql'
        );
    }

    public function getAlias()
    {
        return __CLASS__;
    }
}
