<?php

namespace Dalten\RuianToUir\Converter;

use Dalten\RuianToUir\Converter\Result\CodebookItem as CodebookItemResult;

/**
 * Převaděč hodnot číselníků.
 *
 * Úmyslně neimplementuje rozhraní pro convertery, protože funkce convert musí vracet komplexnější strkturu než je pole.
 */
class CodebookItem extends AbstractConverter
{
    /**
     * {@inheritdoc}
     */
    public function accepts(\XMLReader $document)
    {
        return 0 === strpos($document->name, 'vfc:');
    }

    /**
     * Převede předaný element na Dalten\RuianToUir\Converter\Result\CodebookItem.
     *
     * @param \XMLReader $document
     * @param string     $fallbackContainerTagName Název tagu číselníku (pro případ že jej XMLReader přeskočil).
     *
     * @return CodebookItemResult Nalezená položka číselníku.
     */
    public function convert(\XMLReader $document, $fallbackContainerTagName)
    {
        $this->_handledTag = $element = $document->name;
        $codebookName = $document->localName;
        if ('vfc:Kod' !== $document->name) {
            $this->_getNextElement($document);
        } else {
            $this->_handledTag = (string) preg_replace('/^vf:/', 'vfc:', $fallbackContainerTagName);
            $codebookName = (string) preg_replace('/^\w+:/', '', $fallbackContainerTagName);
        }

        $value = $label = '';
        $continue = $valid = true;
        do {
            switch ($document->name) {
                case 'vfc:Kod':
                    $value = (string) $document->readString();

                    break;
                case 'vfc:Nazev':
                    $label = (string) $document->readString();

                    break;
                case 'vfc:KonecPlatnosti':
                    $valid = false;

                    break;
                case 'vfc:Zkratka':
                case 'vfc:Popis':
                case 'vfc:ZacatekPlatnosti':
                    $this->_skipToElementEnd($document);

                    break;
                default:
                    $continue = false;

                    break;
            }
        } while ($continue && $this->_getNextElement($document));

        return new CodebookItemResult($codebookName, $value, $label, $valid);
    }
}
