<?php

namespace Dalten\RuianToUir\Converter;

use Dalten\RuianToUir\Converter\Field\PointCoordinatesConverter;

/**
 * Převaděč na entitu parcely.
 */
class Plot extends AbstractConverter implements ConverterInterface
{
    /**
     * Nastavuje konfiguraci třídy.
     *
     * @param PointCoordinatesConverter $coordinateConverter
     */
    public function __construct(PointCoordinatesConverter $coordinateConverter)
    {
        parent::__construct($coordinateConverter);
        $this->_handledTag = 'vf:Parcela';
    }

    /**
     * {@inheritdoc}
     */
    public function convert(\XMLReader $document)
    {
        $data = ['stav' => 1];
        while ($this->_getNextElement($document)) {
            switch ($document->name) {
                case 'pai:Id':
                    $data['parcela_kod'] = (int) $document->readString();

                    break;
                case 'pai:KmenoveCislo':
                    $data['kmenove_cislo'] = (int) $document->readString();

                    break;
                case 'pai:PododdeleniCisla':
                    $data['pododdeleni_cisla'] = (int) $document->readString();

                    break;
                case 'pai:DruhCislovaniKod':
                    $data['druh_cislovani'] = (int) $document->readString();

                    break;
                case 'pai:DruhPozemkuKod':
                    $data['druh_pozemku'] = (int) $document->readString();

                    break;
                case 'pai:VymeraParcely':
                    $data['vymera_parcely'] = (int) $document->readString();

                    break;
                case 'pai:KatastralniUzemi':
                    if (!$document->isEmptyElement) {
                        $this->_getNextElement($document);
                        if ('kui:Kod' === $document->name) {
                            $data['ku_kod'] = (int) $document->readString();
                        }
                    }

                    break;
                case 'pai:Geometrie':
                    if (!$document->isEmptyElement) {
                        $data['geom'] = $this->_getGeometryData($document);
                    }

                    break;
                default:
                    $this->_skipToElementEnd($document);

                    break;
            }
        }

        return $data;
    }
}
