<?php

namespace Dalten\RuianToUir\Converter\Result;

/**
 * Společné vlastnosti výsledku zpracování RUIAN záznamu.
 */
interface ResultInterface
{
    const ACTION_TYPE_ADD_RECORD = 1;
    const ACTION_TYPE_REMOVE_RECORD = 2;

    /**
     * Vrátí doplňková data k záznamu (název, vazby, atp.).
     *
     * @return array
     */
    public function getData();

    /**
     * Vrátí typ záznamu. (County, Address, Region, ...).
     *
     * @return string
     */
    public function getItemType();

    /**
     * Vrátí identifikátor (kód) záznamu.
     *
     * @return string|int
     */
    public function getIdentifier();

    /**
     * Vrátí typ akce. (self::ACTION_TYPE_*).
     *
     * @return int
     */
    public function getActionType();
}
